// Objective-C API for talking to github.com/status-im/status-go/mobile Go package.
//   gobind -lang=objc github.com/status-im/status-go/mobile
//
// File is generated by gobind. Do not edit.

#ifndef __Statusgo_H__
#define __Statusgo_H__

@import Foundation;
#include "ref.h"
#include "Universe.objc.h"


@class StatusgoAPIDetailedResponse;
@class StatusgoAPIError;
@class StatusgoAPIFieldError;
@class StatusgoAPIKeyUIDResponse;
@class StatusgoAPIResponse;
@class StatusgoAccountInfo;
@class StatusgoFleetDescription;
@class StatusgoGetPasswordStrengthRequest;
@class StatusgoInitializeApplicationResponse;
@class StatusgoMultiAccountImportMnemonicParams;
@class StatusgoMultiAccountImportPrivateKeyParams;
@class StatusgoNotifyResult;
@class StatusgoOnboardingAccount;
@class StatusgoPasswordScoreResponse;
@protocol StatusgoSignalHandler;
@class StatusgoSignalHandler;

@protocol StatusgoSignalHandler <NSObject>
- (void)handleSignal:(NSString* _Nullable)p0;
@end

/**
 * APIDetailedResponse represents a generic response
with possible errors.
 */
@interface StatusgoAPIDetailedResponse : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) BOOL status;
@property (nonatomic) NSString* _Nonnull message;
// skipped field APIDetailedResponse.FieldErrors with unsupported type: []github.com/status-im/status-go/mobile.APIFieldError

/**
 * Error string representation of APIDetailedResponse.
 */
- (NSString* _Nonnull)error;
@end

/**
 * APIError represents a single error.
 */
@interface StatusgoAPIError : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull message;
/**
 * Error string representation of APIError.
 */
- (NSString* _Nonnull)error;
@end

/**
 * APIFieldError represents a set of errors
related to a parameter.
 */
@interface StatusgoAPIFieldError : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull parameter;
// skipped field APIFieldError.Errors with unsupported type: []github.com/status-im/status-go/mobile.APIError

/**
 * Error string representation of APIFieldError.
 */
- (NSString* _Nonnull)error;
@end

/**
 * APIKeyUIDResponse
 */
@interface StatusgoAPIKeyUIDResponse : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull keyUID;
@end

/**
 * APIResponse generic response from API.
 */
@interface StatusgoAPIResponse : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull error;
@end

/**
 * AccountInfo represents account's info.
 */
@interface StatusgoAccountInfo : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull address;
@property (nonatomic) NSString* _Nonnull pubKey;
@property (nonatomic) NSString* _Nonnull walletAddress;
@property (nonatomic) NSString* _Nonnull walletPubKey;
@property (nonatomic) NSString* _Nonnull chatAddress;
@property (nonatomic) NSString* _Nonnull chatPubKey;
@property (nonatomic) NSString* _Nonnull mnemonic;
@property (nonatomic) NSString* _Nonnull error;
@end

@interface StatusgoFleetDescription : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull defaultFleet;
// skipped field FleetDescription.Fleets with unsupported type: map[string]map[string][]string

@end

@interface StatusgoGetPasswordStrengthRequest : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull password;
// skipped field GetPasswordStrengthRequest.UserInputs with unsupported type: []string

@end

@interface StatusgoInitializeApplicationResponse : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
// skipped field InitializeApplicationResponse.Accounts with unsupported type: []github.com/status-im/status-go/multiaccounts.Account

// skipped field InitializeApplicationResponse.CentralizedMetricsInfo with unsupported type: *github.com/status-im/status-go/centralizedmetrics.MetricsInfo

@end

/**
 * MultiAccountImportMnemonicParams are the params sent to MultiAccountImportMnemonic.
 */
@interface StatusgoMultiAccountImportMnemonicParams : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull mnemonicPhrase;
@property (nonatomic) NSString* _Nonnull bip39Passphrase;
// skipped field MultiAccountImportMnemonicParams.Paths with unsupported type: []string

@end

/**
 * MultiAccountImportPrivateKeyParams are the params sent to MultiAccountImportPrivateKey.
 */
@interface StatusgoMultiAccountImportPrivateKeyParams : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull privateKey;
@end

/**
 * NotifyResult is a JSON returned from notify message.
 */
@interface StatusgoNotifyResult : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) BOOL status;
@property (nonatomic) NSString* _Nonnull error;
@end

/**
 * OnboardingAccount represents accounts info generated for the onboarding.
 */
@interface StatusgoOnboardingAccount : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) NSString* _Nonnull id_;
@property (nonatomic) NSString* _Nonnull address;
@property (nonatomic) NSString* _Nonnull pubKey;
@property (nonatomic) NSString* _Nonnull walletAddress;
@property (nonatomic) NSString* _Nonnull walletPubKey;
@property (nonatomic) NSString* _Nonnull chatAddress;
@property (nonatomic) NSString* _Nonnull chatPubKey;
@end

@interface StatusgoPasswordScoreResponse : NSObject <goSeqRefInterface> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (nonnull instancetype)init;
@property (nonatomic) long score;
@end

FOUNDATION_EXPORT NSString* _Nonnull StatusgoAcceptTerms(void);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoAddCentralizedMetric(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use AppStateChangeV2 instead.
 */
FOUNDATION_EXPORT void StatusgoAppStateChange(NSString* _Nullable state);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoAppStateChangeV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoCallPrivateRPC(NSString* _Nullable inputJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoCallRPC(NSString* _Nullable inputJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoCentralizedMetricsInfo(void);

/**
 * Deprecated: Use ChangeDatabasePasswordV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoChangeDatabasePassword(NSString* _Nullable keyUID, NSString* _Nullable password, NSString* _Nullable newPassword);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoChangeDatabasePasswordV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoCheckAddressChecksum(NSString* _Nullable address);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoColorHash(NSString* _Nullable pk);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoColorID(NSString* _Nullable pk);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoCompressPublicKey(NSString* _Nullable key);

/**
 * Deprecated: Use ConnectionChangeV2 instead.
 */
FOUNDATION_EXPORT void StatusgoConnectionChange(NSString* _Nullable typ, long expensive);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoConnectionChangeV2(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use ConvertToKeycardAccountV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoConvertToKeycardAccount(NSString* _Nullable accountData, NSString* _Nullable settingsJSON, NSString* _Nullable keycardUID, NSString* _Nullable password, NSString* _Nullable newPassword);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoConvertToKeycardAccountV2(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use ConvertToRegularAccountV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoConvertToRegularAccount(NSString* _Nullable mnemonic, NSString* _Nullable currPassword, NSString* _Nullable newPassword);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoConvertToRegularAccountV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoCreateAccountAndLogin(NSString* _Nullable requestJSON);

/**
 * CreateAccountFromMnemonicAndDeriveAccountsForPaths returns an account derived from the mnemonic phrase and the Bip39Passphrase
and generate derived accounts for the list of paths without storing it
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoCreateAccountFromMnemonicAndDeriveAccountsForPaths(NSString* _Nullable paramsJSON);

/**
 * CreateAccountFromPrivateKey returns an account derived from the private key without storing it
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoCreateAccountFromPrivateKey(NSString* _Nullable paramsJSON);

/**
 * Deprecated: no usage in mobile
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoDecodeParameters(NSString* _Nullable decodeParamJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoDecompressPublicKey(NSString* _Nullable key);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoDeserializeAndCompressKey(NSString* _Nullable DesktopKey);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoEmojiHash(NSString* _Nullable pk);

/**
 * Deprecated: Use EncodeFunctionCallV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoEncodeFunctionCall(NSString* _Nullable method, NSString* _Nullable paramsJSON);

/**
 * Deprecated: no usage in mobile, we might implemented it within other functions
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoEncodeFunctionCallV2(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use EncodeTransferV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoEncodeTransfer(NSString* _Nullable to, NSString* _Nullable value);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoEncodeTransferV2(NSString* _Nullable requestJSON);

/**
 * ExportNodeLogs reads current node log and returns content to a caller.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoExportNodeLogs(void);

/**
 * Deprecated: Use ExportUnencryptedDatabaseV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoExportUnencryptedDatabase(NSString* _Nullable accountData, NSString* _Nullable password, NSString* _Nullable databasePath);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoExportUnencryptedDatabaseV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoExtractGroupMembershipSignatures(NSString* _Nullable signaturePairsStr);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoFleets(void);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoGenerateAlias(NSString* _Nullable pk);

/**
 * Deprecated: Use GenerateImagesV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoGenerateImages(NSString* _Nullable filepath, long aX, long aY, long bX, long bY);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoGenerateImagesV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoGetConnectionStringForBeingBootstrapped(NSString* _Nullable configJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoGetConnectionStringForBootstrappingAnotherDevice(NSString* _Nullable configJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoGetConnectionStringForExportingKeypairsKeystores(NSString* _Nullable configJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoGetNodeConfig(void);

/**
 * GetPasswordStrength uses zxcvbn module and generates a JSON containing information about the quality of the given password
(Entropy, CrackTime, CrackTimeDisplay, Score, MatchSequence and CalcTime).
userInputs argument can be whatever list of strings like user's personal info or site-specific vocabulary that zxcvbn will
make use to determine the result.
For more details on usage see https://github.com/status-im/zxcvbn-go
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoGetPasswordStrength(NSString* _Nullable paramsJSON);

/**
 * GetPasswordStrengthScore uses zxcvbn module and gets the score information about the given password.
userInputs argument can be whatever list of strings like user's personal info or site-specific vocabulary that zxcvbn will
make use to determine the result.
For more details on usage see https://github.com/status-im/zxcvbn-go
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoGetPasswordStrengthScore(NSString* _Nullable paramsJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoGetRandomMnemonic(void);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoHashMessage(NSString* _Nullable message);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoHashTransaction(NSString* _Nullable txArgsJSON);

/**
 * HashTypedData unmarshalls data into TypedData, validates it and hashes it.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoHashTypedData(NSString* _Nullable data);

/**
 * HashTypedDataV4 unmarshalls data into TypedData, validates it and hashes it.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoHashTypedDataV4(NSString* _Nullable data);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoHexToNumber(NSString* _Nullable hex);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoHexToUtf8(NSString* _Nullable hexString);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoIdenticon(NSString* _Nullable pk);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoImageServerTLSCert(void);

/**
 * Deprecated: Use ImportUnencryptedDatabaseV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoImportUnencryptedDatabase(NSString* _Nullable accountData, NSString* _Nullable password, NSString* _Nullable databasePath);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoImportUnencryptedDatabaseV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoInitializeApplication(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use InputConnectionStringForBootstrappingV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoInputConnectionStringForBootstrapping(NSString* _Nullable cs, NSString* _Nullable configJSON);

/**
 * Deprecated: Use InputConnectionStringForBootstrappingAnotherDeviceV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoInputConnectionStringForBootstrappingAnotherDevice(NSString* _Nullable cs, NSString* _Nullable configJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoInputConnectionStringForBootstrappingAnotherDeviceV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoInputConnectionStringForBootstrappingV2(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use InputConnectionStringForImportingKeypairsKeystoresV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoInputConnectionStringForImportingKeypairsKeystores(NSString* _Nullable cs, NSString* _Nullable configJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoInputConnectionStringForImportingKeypairsKeystoresV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoIntendedPanic(NSString* _Nullable message);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoIsAddress(NSString* _Nullable address);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoIsAlias(NSString* _Nullable value);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoLoadLocalBackup(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoLocalPairingPreflightOutboundCheck(void);

/**
 * Login loads a key file (for a given address), tries to decrypt it using the password,
to verify ownership if verified, purges all the previous identities from Whisper,
and injects verified key as shh identity.

Deprecated: Use LoginAccount instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoLogin(NSString* _Nullable accountData, NSString* _Nullable password);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoLoginAccount(NSString* _Nullable requestJSON);

/**
 * LoginWithConfig loads a key file (for a given address), tries to decrypt it using the password,
to verify ownership if verified, purges all the previous identities from Whisper,
and injects verified key as shh identity. It then updates the accounts node db configuration
mergin the values received in the configJSON parameter

Deprecated: Use LoginAccount instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoLoginWithConfig(NSString* _Nullable accountData, NSString* _Nullable password, NSString* _Nullable configJSON);

/**
 * LoginWithKeycard initializes an account with a chat key and encryption key used for PFS.
It purges all the previous identities from Whisper, and injects the key as shh identity.
Deprecated: Use LoginAccount instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoLoginWithKeycard(NSString* _Nullable accountData, NSString* _Nullable password, NSString* _Nullable keyHex, NSString* _Nullable configJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoLogout(void);

/**
 * Deprecated: Use MigrateKeyStoreDirV2 instead
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoMigrateKeyStoreDir(NSString* _Nullable accountData, NSString* _Nullable password, NSString* _Nullable oldDir, NSString* _Nullable newDir);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoMigrateKeyStoreDirV2(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use MultiformatDeserializePublicKeyV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoMultiformatDeserializePublicKey(NSString* _Nullable key, NSString* _Nullable outBase);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoMultiformatDeserializePublicKeyV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoMultiformatSerializePublicKey(NSString* _Nullable key, NSString* _Nullable outBase);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoNumberToHex(NSString* _Nullable numString);

/**
 * Deprecated: Use InitializeApplication instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoOpenAccounts(NSString* _Nullable datadir);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoPerformLocalBackup(void);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoRecover(NSString* _Nullable rpcParams);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoResetChainData(void);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoRestoreAccountAndLogin(NSString* _Nullable requestJSON);

/**
 * SaveAccountAndLogin saves account in status-go database.
Deprecated: Use CreateAccountAndLogin instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSaveAccountAndLogin(NSString* _Nullable accountData, NSString* _Nullable password, NSString* _Nullable settingsJSON, NSString* _Nullable configJSON, NSString* _Nullable subaccountData);

/**
 * Deprecated: Use SendTransactionV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSendTransaction(NSString* _Nullable txArgsJSON, NSString* _Nullable password);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSendTransactionV2(NSString* _Nullable requestJSON);

/**
 * SendTransactionWithChainID converts RPC args and calls backend.SendTransactionWithChainID.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSendTransactionWithChainID(long chainID, NSString* _Nullable txArgsJSON, NSString* _Nullable password);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSendTransactionWithSignature(NSString* _Nullable txArgsJSON, NSString* _Nullable sigString);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSerializeLegacyKey(NSString* _Nullable key);

/**
 * Deprecated: Use SetProfileLogEnabled instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSetLogEnabled(NSString* _Nullable requestJSON);

/**
 * Deprecated: Use SetProfileLogLevel instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSetLogLevel(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSetLogNamespaces(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT void StatusgoSetMobileSignalHandler(id<StatusgoSignalHandler> _Nullable handler);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSetPreLoginLogEnabled(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSetPreLoginLogLevel(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSetProfileLogEnabled(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSetProfileLogLevel(NSString* _Nullable requestJSON);

// skipped function SetSignalEventCallback with unsupported parameter or return types


FOUNDATION_EXPORT NSString* _Nonnull StatusgoSha3(NSString* _Nullable str);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSignGroupMembership(NSString* _Nullable content);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSignHash(NSString* _Nullable hexEncodedHash);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSignMessage(NSString* _Nullable rpcParams);

/**
 * SignTypedData unmarshall data into TypedData, validate it and signs with selected account,
if password matches selected account.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSignTypedData(NSString* _Nullable data, NSString* _Nullable address, NSString* _Nullable password);

/**
 * SignTypedDataV4 unmarshall data into TypedData, validate it and signs with selected account,
if password matches selected account.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSignTypedDataV4(NSString* _Nullable data, NSString* _Nullable address, NSString* _Nullable password);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoStartCPUProfile(NSString* _Nullable dataDir);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoStartLocalNotifications(void);

/**
 * StartProfiling starts profiling and HTTP server for pprof
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoStartProfiling(NSString* _Nullable address);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoStartSearchForLocalPairingPeers(void);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoStopCPUProfiling(void);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoStopLocalNotifications(void);

/**
 * Deprecated: Use SwitchFleetV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoSwitchFleet(NSString* _Nullable fleet, NSString* _Nullable configJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoSwitchFleetV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoToChecksumAddress(NSString* _Nullable address);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoToggleCentralizedMetrics(NSString* _Nullable requestJSON);

/**
 * Deprecated: no usage in mobile
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoUtf8ToHex(NSString* _Nullable str);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoValidateConnectionString(NSString* _Nullable cs);

/**
 * Deprecated: Use ValidateMnemonicV2 instead.
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoValidateMnemonic(NSString* _Nullable mnemonic);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoValidateMnemonicV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoValidateNodeConfig(NSString* _Nullable configJSON);

/**
 * Deprecated: Use VerifyAccountPasswordV2 instead
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoVerifyAccountPassword(NSString* _Nullable address, NSString* _Nullable password);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoVerifyAccountPasswordV2(NSString* _Nullable requestJSON);

/**
 * Deprecated: use VerifyDatabasePasswordV2 instead
 */
FOUNDATION_EXPORT NSString* _Nonnull StatusgoVerifyDatabasePassword(NSString* _Nullable keyUID, NSString* _Nullable password);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoVerifyDatabasePasswordV2(NSString* _Nullable requestJSON);

FOUNDATION_EXPORT NSString* _Nonnull StatusgoWriteHeapProfile(NSString* _Nullable dataDir);

@class StatusgoSignalHandler;

/**
 * SignalHandler defines a minimal interface
a signal handler needs to implement.
 */
@interface StatusgoSignalHandler : NSObject <goSeqRefInterface, StatusgoSignalHandler> {
}
@property(strong, readonly) _Nonnull id _ref;

- (nonnull instancetype)initWithRef:(_Nonnull id)ref;
- (void)handleSignal:(NSString* _Nullable)p0;
@end

#endif
